unit Unit1;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics, Vcl.Controls,
  Vcl.Forms, Vcl.Dialogs, bass, bassdts, Vcl.StdCtrls;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    lblLen: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure Error(const Text: string);
    function GetStreamLen(Chan: Hstream): int64;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  Chan: HSTREAM;

implementation

{$R *.dfm}

function TimeToStringEx(Ftime: int64; ShowMsec: Boolean = true): string;
begin
  if ShowMsec then
  begin

    if Time >= 3600000 then
      Result := Format('%d:%2.2d:%2.2d,%3.3d', [Ftime div 3600000,
          (Ftime mod 3600000) div 60000,
          (Ftime mod 60000) div 1000,
          Ftime mod 1000])
    else
      Result := Format('%d:%2.2d,%3.3d', [Ftime div 60000,
          (Ftime mod 60000) div 1000,
          Ftime mod 1000]);
  end
  else
  begin
    if Ftime >= 3600000 then
      Result := Format('%d:%2.2d:%2.2d', [Ftime div 3600000,
          (Ftime mod 3600000) div 60000,
          (Ftime mod 60000) div 1000])
    else
      Result := Format('%d:%2.2d', [Ftime div 60000,
          (Ftime mod 60000) div 1000]);
  end;
end;

function ProgDir: string;
begin
  result := ExtractFilePath(ParamStr(0));
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    BASS_StreamFree(Chan);
    Chan := BASS_DTS_StreamCreateFile(false, PWideChar(OpenDialog1.FileName), 0, 0, BASS_STREAM_DECODE or BASS_UNICODE or
      BASS_SAMPLE_FLOAT);
    if Chan <> 0 then
      lblLen.Caption := 'Length ' + TimeToStringEx(GetStreamLen(Chan), true);
     // we only need the Length so we can free the channel
    BASS_StreamFree(Chan);
  end;
end;

procedure TForm1.Error(const Text: string);
begin
  MessageBox(Handle, PChar(Text + '  Errorcode = ' +
      inttostr(Bass_ErrorGetCode)), PChar('Error'), 16);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  if not Bass_Init(-1, 44100, 0, handle, nil) then
  begin
    Error('Can''t initialize device');
    Application.Terminate;
  end;
end;

function TForm1.GetStreamLen(Chan: Hstream): int64;
begin
  Result := Round(BASS_ChannelBytes2Seconds(Chan, BASS_ChannelGetLength(Chan, BASS_POS_BYTE)) * 1000);
end;

end.

